---
title: Gfpgan API Usage Guide
createdAt: Thu Jul 18 2024 06:12:37 GMT+0000 (Coordinated Universal Time)
updatedAt: Thu Jul 18 2024 13:40:04 GMT+0000 (Coordinated Universal Time)
---

# Gfpgan API Usage Guide

## Introduction

This document will guide developers on how to use the aonweb library to call the Gfpgan API, is a deep learning model for high-quality facial image restoration, enhancing details and correcting distortions in old or low-resolution photos.

## Prerequisites

- Node.js environment
- `aonweb` library installed
- Valid Aonet APPID

## Basic Usage

### 1. Import Required Modules

```js
import { AI, AIOptions } from 'aonweb';
```

### 2. Initialize AI Instance

```js
const ai_options = new AIOptions({
    appId: 'your_app_id_here',
    dev_mode: true
});

const aonweb = new AI(ai_options);
```

### 3. Prepare Input Data Example

```js
const data = {
   input:{
    "img": "https://replicate.delivery/mgxm/59d9390c-b415-47e0-a907-f81b0d9920f1/187400315-87a90ac9-d231-45d6-b377-38702bd1838f.jpg",
    "scale": 2,
    "version": "v1.4"
  }
};
```

### 4. Call the AI Model

```js
const price = 8; // Cost of the AI call
try {
    const response = await aonweb.prediction("/predictions/ai/gfpgan@lucataco", data, price);
    // Handle response
    console.log("Gfpgan result:", response);
} catch (error) {
    // Error handling
    console.error("Error generating :", error);
}
```

### Parameter Description

- `img`: String, Provide the image file that needs optimization.
- `scale`: Number, Rescaling factor.
- `version`: String, GFPGAN version. v1.3: better quality. v1.4: more details and better identity.

### Notes

- Ensure that the provided image URL is publicly accessible and of good quality to achieve the best recognition results.
- The API may take some time to process the input and generate the result, consider implementing appropriate wait or loading states
- Handle possible errors, such as network issues, invalid input, or API limitations.
- Adhere to the terms of use and privacy regulations, especially when handling image samples of others.

### Example Response

The API response will contain the URL of the generated cloned voice or other relevant information. Parse and use the response data according to the actual API documentation.


